#include <iostream>
#include <vector>
#include <queue>

using namespace std;

vector<int> findSmallestJumps(int N, vector<vector<int>>& connections, vector<int>& platforms, vector<int>& stateChanges) {
    vector<vector<int>> graph(N + 1);
    vector<int> jumps(N + 1, -1);
    vector<bool> visited(N + 1, false);
    
    for (auto& connection : connections) {
        int u = connection[0];
        int v = connection[1];
        graph[u].push_back(v);
    }
    
    queue<int> q;
    q.push(1);
    jumps[1] = 0;
    visited[1] = true;
    
    while (!q.empty()) {
        int curr = q.front();
        q.pop();
        
        for (int next : graph[curr]) {
            if (!visited[next]) {
                visited[next] = true;
                jumps[next] = jumps[curr] + 1;
                q.push(next);
            }
        }
        
        if (platforms[curr] == 0 && stateChanges[curr] != 0) {
            int next = stateChanges[curr];
            if (!visited[next]) {
                visited[next] = true;
                jumps[next] = jumps[curr] + 1;
                q.push(next);
            }
        }
    }
    
    vector<int> result;
    for (int i = 1; i <= N; i++) {
        result.push_back(jumps[i]);
    }
    
    return result;
}

int main() {
    int N;
    cin >> N;
    
    vector<vector<int>> connections(N - 1, vector<int>(2));
    for (int i = 0; i < N - 1; i++) {
        cin >> connections[i][0] >> connections[i][1];
    }
    
    vector<int> platforms(N);
    for (int i = 0; i < N; i++) {
        cin >> platforms[i];
    }
    
    vector<int> stateChanges(N);
    for (int i = 0; i < N; i++) {
        cin >> stateChanges[i];
    }
    
    vector<int> jumps = findSmallestJumps(N, connections, platforms, stateChanges);
    
    for (int i = 0; i < N; i++) {
        cout << jumps[i] << " ";
    }
    
    return 0;
}